# -*- coding: utf-8 -*-
"""
Created on Mon May  3 17:21:42 2021

@author: Dyrvik
"""
import numpy as np
import matplotlib.pyplot as plt
import matplotlib.cm as cm
import matplotlib as mpl
import seaborn as sns
import pandas as pd
import os
from mpl_toolkits.axes_grid1 import Divider, Size

"""Colourmaps"""
CM_SUBSECTION_GREENS = np.linspace(0.4, 1.0, 1000) 
COLOURS_GREENS = [ cm.Greens(x) for x in CM_SUBSECTION_GREENS ]

"""File handling"""
main_folder_path = os.path.dirname(os.path.abspath(__file__))
main_folder_path = '\\\\?\\' + main_folder_path
data_folder_path = main_folder_path
export_folder_path = main_folder_path
# =============================================================================
# export_folder_name = 'Plots'
# export_folder_path = os.path.join(main_folder_path,export_folder_name)
# if not os.path.exists(export_folder_path):
#     os.mkdir(export_folder_path) # create folder if non-existent
# =============================================================================

file_name = 'igled19-batch11 scan measurements analysis summary 2021-03-23 selected params.csv'
file_path = os.path.join(data_folder_path, file_name)
df = pd.read_csv(file_path)

"""Some constants for graphical settings"""
lw = 3
ticksize_major = 8
ticksize_minor = 8  

"""Box swarm plot general graphic settings"""
boxcolour = COLOURS_GREENS[650]
boxprops = {'edgecolor': boxcolour, 'linewidth': lw*1.5, 'facecolor': 'w'}
lineprops = {'color': boxcolour, 'linewidth': lw*1.5}
boxplot_kwargs = dict({'boxprops': boxprops, 'medianprops': lineprops,
                       'whiskerprops': lineprops, 'capprops': lineprops,
                       'width': 0.75})

"""Plotting the box swarm plot"""
fig = plt.figure(figsize=(7.5, 7.5))
h = [Size.Fixed(1.0), Size.Scaled(1.), Size.Fixed(.2)]
v = [Size.Fixed(0.7), Size.Scaled(1.), Size.Fixed(.5)]
divider = Divider(fig, (0, 0, 1, 1), h, v, aspect=False)
# The width and height of the rectangle are ignored.
ax = plt.axes([0.15, 0.15, 0.85, 0.85])

order = ['No TFB', 'ALD then TFB', 'TFB then ALD']
sns.boxplot(x=df['Architecture'], y=df['Peak EQE [%]'], ax=ax, order=order, fliersize=0, saturation=1, **boxplot_kwargs)
sns.swarmplot(x=df['Architecture'], y=df['Peak EQE [%]'], ax=ax, order=order, color='w', edgecolor=boxcolour, linewidth=lw, size=8)

"""Axis details"""
plt.xticks((0,1,2), ('A', 'B', 'C'))
ax.set_xlabel('Device Type')
ax.set_ylabel('$\mathregular{EQE_{EL}}$ [%]')
ax.set_ylim(bottom=0, top=14)
ax.yaxis.set_major_locator(mpl.ticker.MultipleLocator(2))
ax.yaxis.set_minor_locator(mpl.ticker.MultipleLocator(1))

"""Annotation"""
ax.text(0.95, 0.05, '10 cycles $\mathrm{Al_2O_3}$\n11 nm TFB',
        horizontalalignment='right',
        verticalalignment='bottom',
        transform=ax.transAxes)

ax.text(0.03, 0.97, '(A) ITO/$\mathrm{Al_2O_3}$/LiF/Perov.\n(B) ITO/$\mathrm{Al_2O_3}$/TFB/LiF/P.\n(C) ITO/TFB/$\mathrm{Al_2O_3}$/LiF/P.',
        horizontalalignment='left',
        verticalalignment='top',
        transform=ax.transAxes)

"""Graphical details"""
plt.rcParams['font.size'] = 24
plt.rc('axes', labelsize=30)    # fontsize of the x and y labels
plt.rcParams['axes.linewidth'] = lw
plt.rcParams['lines.linewidth'] = lw

ax.xaxis.set_tick_params(which='major', size=ticksize_major, width=lw)
ax.xaxis.set_tick_params(which='minor', size=ticksize_minor, width=lw)
ax.yaxis.set_tick_params(which='major', size=ticksize_major, width=lw)
ax.yaxis.set_tick_params(which='minor', size=ticksize_minor, width=lw)

"""Exporting plots"""
plot_name = 'Plot EQE Other Configs box swarm'
export_name_pdf = plot_name + '.pdf'
export_name_svg = plot_name + '.svg'
#export_name_eps = plot_name + '.eps'
pdf_path = os.path.join(export_folder_path,export_name_pdf)
svg_path = os.path.join(export_folder_path,export_name_svg)
#eps_path = os.path.join(export_folder_path,export_name_eps)
if len(pdf_path) > 255:
    warning_string = 'Warning: plot file path longer than 255 characters, downstream handling issues may occur. Path: ' + pdf_path
    print(warning_string)
fig.savefig(pdf_path, bbox_inches='tight')
fig.savefig(svg_path, bbox_inches='tight')
#fig.savefig(eps_path, bbox_inches='tight')
plt.close(fig)
